/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.parser.nodes;

import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.editor.php.internal.parser.nodes.NodeBuilder;
import java.util.Collections;
import java.util.List;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.CatchClause;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.DoStatement;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org2.eclipse.php.internal.core.ast.nodes.ForStatement;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.FunctionName;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.IfStatement;
import org2.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org2.eclipse.php.internal.core.ast.nodes.Include;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org2.eclipse.php.internal.core.ast.nodes.Scalar;
import org2.eclipse.php.internal.core.ast.nodes.Statement;
import org2.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org2.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org2.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.TryStatement;
import org2.eclipse.php.internal.core.ast.nodes.UseStatement;
import org2.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org2.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org2.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.BasicPHPDocTag;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;
import org2.eclipse.php.internal.core.documentModel.phpElementData.PHPDocBlockImp;

public final class NodeBuildingVisitor
extends AbstractVisitor {
    private static final String DEFINE = "define";
    private NodeBuilder nodeBuilder;
    private String source;

    public NodeBuildingVisitor(NodeBuilder nodeBuilder, String source) {
        this.nodeBuilder = nodeBuilder;
        this.source = source;
    }

    public boolean visit(InLineHtml inLineHtml) {
        this.nodeBuilder.handleInlineHtml(inLineHtml.getStart(), inLineHtml.getEnd());
        return super.visit(inLineHtml);
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        Identifier nameIdentifier = interfaceDeclaration.getName();
        String name = nameIdentifier.getName();
        PHPDocBlock docComment = PHPDocUtils.findPHPDocComment(interfaceDeclaration.getProgramRoot().comments(), interfaceDeclaration.getStart(), this.source);
        PHPDocBlockImp docBlock = this.convertToDocBlock(docComment);
        this.nodeBuilder.handleClassDeclaration(name, 8, (IPHPDocBlock)docBlock, interfaceDeclaration.getStart(), interfaceDeclaration.getEnd() - 1, -1);
        List interfaces = interfaceDeclaration.interfaces();
        this.handleInterfaces(interfaces);
        this.nodeBuilder.setNodeName(nameIdentifier);
        return super.visit(interfaceDeclaration);
    }

    public boolean visit(TraitDeclaration traitDeclaration) {
        Identifier nameIdentifier = traitDeclaration.getName();
        String name = nameIdentifier.getName();
        PHPDocBlock docComment = PHPDocUtils.findPHPDocComment(traitDeclaration.getProgramRoot().comments(), traitDeclaration.getStart(), this.source);
        PHPDocBlockImp docBlock = this.convertToDocBlock(docComment);
        this.nodeBuilder.handleTraitDeclaration(name, traitDeclaration.getModifier(), (IPHPDocBlock)docBlock, traitDeclaration.getStart(), traitDeclaration.getEnd() - 1, -1);
        Expression superClass = traitDeclaration.getSuperClass();
        if (superClass != null && superClass.getType() == 33) {
            Identifier superClassName = (Identifier)superClass;
            this.nodeBuilder.handleTraitSuperclass(superClassName.getName(), superClassName.getStart(), superClassName.getEnd() - 1);
        }
        List interfaces = traitDeclaration.interfaces();
        this.handleInterfaces(interfaces);
        this.nodeBuilder.setNodeName(nameIdentifier);
        return super.visit(traitDeclaration);
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        Identifier nameIdentifier = classDeclaration.getName();
        String name = nameIdentifier.getName();
        PHPDocBlock docComment = PHPDocUtils.findPHPDocComment(classDeclaration.getProgramRoot().comments(), classDeclaration.getStart(), this.source);
        PHPDocBlockImp docBlock = this.convertToDocBlock(docComment);
        this.nodeBuilder.handleClassDeclaration(name, classDeclaration.getModifier(), (IPHPDocBlock)docBlock, classDeclaration.getStart(), classDeclaration.getEnd() - 1, -1);
        Expression superClass = classDeclaration.getSuperClass();
        if (superClass != null && superClass.getType() == 33) {
            Identifier superClassName = (Identifier)superClass;
            this.nodeBuilder.handleSuperclass(superClassName.getName(), superClassName.getStart(), superClassName.getEnd() - 1);
        }
        List interfaces = classDeclaration.interfaces();
        this.handleInterfaces(interfaces);
        this.nodeBuilder.setNodeName(nameIdentifier);
        return super.visit(classDeclaration);
    }

    public boolean visit(FieldsDeclaration fieldsDeclaration) {
        int modifier = fieldsDeclaration.getModifier();
        int startPosition = -1;
        int endPosition = -1;
        IPHPDocBlock docInfo = null;
        StringBuilder vars = new StringBuilder();
        Variable[] variableArray = fieldsDeclaration.getVariableNames();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable v = variableArray[n2];
            Expression variableName = v.getName();
            if (variableName.getType() == 33) {
                if (startPosition < 0) {
                    startPosition = variableName.getStart();
                }
                endPosition = variableName.getEnd();
                vars.append(((Identifier)variableName).getName());
                vars.append(',');
            }
            ++n2;
        }
        vars = vars.deleteCharAt(vars.length() - 1);
        String variables = vars.toString();
        if (startPosition < 0 || endPosition < 0) {
            startPosition = fieldsDeclaration.getStart();
            endPosition = fieldsDeclaration.getEnd();
        }
        int stopPosition = endPosition - 1;
        this.nodeBuilder.handleClassVariablesDeclaration(variables, modifier, docInfo, startPosition, endPosition - 1, stopPosition);
        return super.visit(fieldsDeclaration);
    }

    public boolean visit(Include include) {
        int includeT = include.getIncludeType();
        String includeType = "include";
        switch (includeT) {
            case 2: {
                includeType = "include";
                break;
            }
            case 3: {
                includeType = "include_once";
                break;
            }
            case 1: {
                includeType = "require_once";
                break;
            }
            case 0: {
                includeType = "require";
                break;
            }
        }
        Expression expr = include.getExpression();
        if (expr != null && expr.getType() == 62) {
            ParenthesisExpression pa = (ParenthesisExpression)expr;
            expr = pa.getExpression();
        }
        String expStringValue = null;
        if (expr != null) {
            int type = expr.getType();
            if (type == 51) {
                expStringValue = ((Scalar)expr).getStringValue();
            } else if (type == 37) {
                expStringValue = this.source.substring(expr.getStart(), expr.getEnd());
            }
        }
        if (expStringValue != null) {
            this.nodeBuilder.handleIncludedFile(includeType, expStringValue, null, expr.getStart(), expr.getEnd() - 1, -1, -1);
        }
        return super.visit(include);
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Expression param;
        Variable nameVar;
        FunctionName funcName = functionInvocation.getFunctionName();
        if (funcName == null) {
            return super.visit(functionInvocation);
        }
        Expression name = funcName.getName();
        if (name instanceof Identifier && !DEFINE.equals(((Identifier)name).getName().toLowerCase())) {
            return super.visit(functionInvocation);
        }
        if (name instanceof Variable && (name = (nameVar = (Variable)name).getName()) instanceof Identifier && !DEFINE.equals(((Identifier)name).getName())) {
            return super.visit(functionInvocation);
        }
        List parameters = functionInvocation.parameters();
        if (parameters.size() >= 2 && (param = (Expression)parameters.get(0)).getType() == 51 && 2 == ((Scalar)param).getScalarType()) {
            String define = ((Scalar)param).getStringValue();
            if (define.startsWith("\"")) {
                define = define.substring(1);
            }
            if (define.endsWith("\"")) {
                define = define.substring(0, define.length() - 1);
            }
            if (define.startsWith("'")) {
                define = define.substring(1);
            }
            if (define.endsWith("'")) {
                define = define.substring(0, define.length() - 1);
            }
            PHPDocBlock docComment = PHPDocUtils.findPHPDocComment(functionInvocation.getProgramRoot().comments(), functionInvocation.getStart(), this.source);
            PHPDocBlockImp docBlock = this.convertToDocBlock(docComment);
            this.nodeBuilder.handleDefine(define, null, (IPHPDocBlock)docBlock, param.getStart(), param.getEnd() - 1, -1);
        }
        return super.visit(functionInvocation);
    }

    public boolean visit(ConstantDeclaration node) {
        List variableNames = node.names();
        for (Identifier i : variableNames) {
            this.nodeBuilder.handleDefine(i.getName(), null, null, i.getStart(), node.getEnd() - 1, -1);
        }
        return super.visit(node);
    }

    public boolean visit(NamespaceDeclaration node) {
        NamespaceName name = node.getName();
        List segments = name == null ? Collections.emptyList() : name.segments();
        StringBuilder stringBuilder = new StringBuilder();
        for (Identifier i : segments) {
            stringBuilder.append(i.getName());
            stringBuilder.append('\\');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        String segmentsString = stringBuilder.toString();
        int nameEndOffset = name != null ? name.getEnd() - 1 : node.getStart() + 8;
        this.nodeBuilder.handleNamespaceDeclaration(segmentsString, node.getStart(), node.getEnd() - 1, nameEndOffset);
        return super.visit(node);
    }

    public boolean visit(UseStatement node) {
        List parts = node.parts();
        for (UseStatementPart p : parts) {
            Identifier alias = p.getAlias();
            List segments = p.getName().segments();
            StringBuilder stringBuilder = new StringBuilder();
            for (Identifier i : segments) {
                stringBuilder.append(i.getName());
                stringBuilder.append('\\');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            String segmentsString = stringBuilder.toString();
            this.nodeBuilder.handleUse(segmentsString, alias != null ? alias.getName() : null, node.getStart(), node.getEnd() - 1);
        }
        return super.visit(node);
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        ASTNode parent = functionDeclaration.getParent();
        boolean isClassFunction = parent != null && parent.getType() == 42;
        int modifiers = 0;
        if (isClassFunction) {
            MethodDeclaration md = (MethodDeclaration)functionDeclaration.getParent();
            modifiers = md.getModifier();
        }
        List formalParameters = functionDeclaration.formalParameters();
        for (FormalParameter p : formalParameters) {
            String type = null;
            String vName = null;
            String defaultVal = null;
            Expression parameterType = p.getParameterType();
            Expression parameterName = p.getParameterName();
            Expression defaultValue = p.getDefaultValue();
            if (parameterType != null && parameterType.getType() == 60) {
                type = ((Identifier)((Variable)parameterType).getName()).getName();
            }
            if (parameterName != null && parameterName.getType() == 60) {
                vName = ((Identifier)((Variable)parameterName).getName()).getName();
            }
            if (defaultValue != null && defaultValue.getType() == 51) {
                defaultVal = ((Scalar)defaultValue).getStringValue();
            }
            this.nodeBuilder.handleFunctionParameter(type, vName, false, false, defaultVal, p.getStart(), p.getEnd(), p.getEnd() - 1, -1);
        }
        Identifier functionName = functionDeclaration.getFunctionName();
        PHPDocBlock docComment = PHPDocUtils.findPHPDocComment(functionDeclaration.getProgramRoot().comments(), functionDeclaration.getStart(), this.source);
        PHPDocBlockImp docBlock = this.convertToDocBlock(docComment);
        this.nodeBuilder.handleFunctionDeclaration(functionName.getName(), isClassFunction, modifiers, (IPHPDocBlock)docBlock, functionDeclaration.getStart(), functionDeclaration.getEnd() - 1, -1);
        this.nodeBuilder.setNodeName(functionName);
        return super.visit(functionDeclaration);
    }

    public boolean visit(TryStatement tryStatement) {
        List catchClauses = tryStatement.catchClauses();
        int end = tryStatement.getEnd();
        if (catchClauses != null && !catchClauses.isEmpty()) {
            end = ((CatchClause)catchClauses.get(0)).getStart() - 1;
        }
        this.nodeBuilder.handleTryStatement(tryStatement.getStart(), end);
        return super.visit(tryStatement);
    }

    public boolean visit(CatchClause catchClause) {
        this.nodeBuilder.handleCatchStatement(catchClause.getStart(), catchClause.getEnd());
        return super.visit(catchClause);
    }

    public boolean visit(DoStatement doStatement) {
        this.nodeBuilder.handleDoStatement(doStatement.getStart(), doStatement.getEnd());
        return super.visit(doStatement);
    }

    public boolean visit(ForEachStatement forEachStatement) {
        this.nodeBuilder.handleForEachStatement(forEachStatement.getStart(), forEachStatement.getEnd());
        return super.visit(forEachStatement);
    }

    public boolean visit(ForStatement forStatement) {
        this.nodeBuilder.handleForStatement(forStatement.getStart(), forStatement.getEnd());
        return super.visit(forStatement);
    }

    public boolean visit(IfStatement ifStatement) {
        Statement trueStatement = ifStatement.getTrueStatement();
        Statement falseStatement = ifStatement.getFalseStatement();
        if (trueStatement != null && trueStatement.getType() != 34) {
            this.nodeBuilder.handleIfElseStatement(trueStatement.getStart(), trueStatement.getEnd(), "if");
        }
        if (falseStatement != null) {
            this.nodeBuilder.handleIfElseStatement(falseStatement.getStart(), falseStatement.getEnd(), "else");
        }
        return super.visit(ifStatement);
    }

    public boolean visit(SwitchCase switchCase) {
        this.nodeBuilder.handleSwitchCaseStatement(switchCase.getStart(), switchCase.getEnd());
        return super.visit(switchCase);
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.nodeBuilder.handleSwitchStatement(switchStatement.getStart(), switchStatement.getEnd());
        return super.visit(switchStatement);
    }

    public boolean visit(WhileStatement whileStatement) {
        this.nodeBuilder.handleWhileStatement(whileStatement.getStart(), whileStatement.getEnd());
        return super.visit(whileStatement);
    }

    public void endVisit(CatchClause catchClause) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(DoStatement doStatement) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(ForEachStatement forEachStatement) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(ForStatement forStatement) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(IfStatement ifStatement) {
        if (ifStatement.getTrueStatement() != null && ifStatement.getTrueStatement().getType() != 34) {
            this.nodeBuilder.handleCommonDeclarationEnd();
        }
        if (ifStatement.getFalseStatement() != null) {
            this.nodeBuilder.handleCommonDeclarationEnd();
        }
    }

    public void endVisit(SwitchCase switchCase) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(SwitchStatement switchStatement) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(TryStatement tryStatement) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(WhileStatement whileStatement) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(TraitDeclaration traitDeclaration) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(ClassDeclaration classDeclaration) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(FunctionDeclaration functionDeclaration) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(InterfaceDeclaration interfaceDeclaration) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    public void endVisit(NamespaceDeclaration namespaceDeclaration) {
        this.nodeBuilder.handleCommonDeclarationEnd();
    }

    private void handleInterfaces(List<Identifier> interfaces) {
        String[] extendedInterfacesNames = new String[interfaces.size()];
        int[][] extendedInterfacesStartEnd = new int[extendedInterfacesNames.length][2];
        int i = 0;
        while (i < extendedInterfacesNames.length) {
            Identifier interfaceName = interfaces.get(i);
            extendedInterfacesNames[i] = interfaceName.getName();
            extendedInterfacesStartEnd[i][0] = interfaceName.getStart();
            extendedInterfacesStartEnd[i][1] = interfaceName.getEnd() - 1;
            ++i;
        }
        this.nodeBuilder.handleImplements(extendedInterfacesNames, extendedInterfacesStartEnd);
    }

    private PHPDocBlockImp convertToDocBlock(PHPDocBlock docComment) {
        if (docComment == null) {
            return null;
        }
        IPHPDocTag[] docTags = docComment.getTags();
        IPHPDocTag[] tags = new IPHPDocTag[docTags.length];
        int i = 0;
        while (i < docTags.length) {
            tags[i] = BasicPHPDocTag.fromASTDocTag((IPHPDocTag)docTags[i]);
            ++i;
        }
        return new PHPDocBlockImp(docComment.getShortDescription(), "", tags, docComment.getCommentType());
    }
}

